#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "2LinesIntersect", Category = "Value", Help = "2 lines intersect", Tags = "")]
	//Source:
    //http://paulbourke.net/geometry/lineline2d/
    //Credits:
    //Lasal 2011

	#endregion PluginInfo
	public class Value2LinesIntersectNode : IPluginEvaluate
	{
		#region fields & pins
		
		[Input("L1_Point1")]
		ISpread<Vector2D> P1;
		
		[Input("L1_Point2")]
		ISpread<Vector2D> P2;
		
		[Input("L2_Point1")]
		ISpread<Vector2D> P3;
		
		[Input("L2_Point2")]
		ISpread<Vector2D> P4;
		
		[Output("Intersection")]
		ISpread<Vector2D> FIntersection;
		
		
		
		[Output("Number of Solutions")]
		ISpread<int> FSolutionCount;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
 
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FIntersection.SliceCount = SpreadMax;
		
			FSolutionCount.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++)
				{
				Vector2D s1;
			
				
				FSolutionCount[i] = LinesIntersection( P1[i], P2[i] , P3[i], P4[i], out s1);
				FIntersection[i] = s1;
			
			}
				
			
		}
		private int LinesIntersection ( Vector2D P1 , Vector2D P2, Vector2D P3 , Vector2D P4, out Vector2D sol)
		{
			sol = new Vector2D();
			
		
		// Denominator for ua and ub are the same, so store this calculation
         double d =
            (P4.y - P3.y) * (P2.x - P1.x)
            -
            (P4.x - P3.x) * (P2.y - P1.y);

         //n_a and n_b are calculated as seperate values for readability
         double n_a =
            (P4.x - P3.x) * (P1.y - P3.y)
            -
            (P4.y - P3.y) * (P1.x - P3.x);

         double n_b =
            (P2.x - P1.x) * (P1.y - P2.y)
            -
            (P2.y - P1.y) * (P1.x - P2.x);
         
         // Calculate the intermediate fractional point that the lines potentially intersect.
         double ua = n_a / d;
         double ub = n_b / d;
         
         double   SX = P1.x + (ua * (P2.x - P1.x));
         double   SY = P1.y + (ua * (P2.y - P1.y));
        
        if (d == 0)   // Parallel lines.
        {
            return 0;
            }
            
        if (SX < P1.x & SX < P2.x | 
            SY < P1.y & SY < P2.y | 
            SX > P1.x & SX > P2.x | 
            SY > P1.y & SY > P2.y )  
            // No finite lines intersecting, delete this for infinite lines Intersection.
            {
            return 0;
            }
       
         
          // than 0 the lines would need to be longer to intersect.
         if (ua >= 0d && ua <= 1d && ub >= 0d && ub <= 1d)
         {
            sol.x = SX;
            sol.y = SY;
            return 1;
            }

           
            {
			return 0;    
} 
}
}}

